﻿using Percent___Qualification_work.Classes;
using System;
using System.Security.Cryptography;
using System.Text;
using System.Windows.Forms;

namespace Percent___Qualification_work.Classes
{
    public class Authentication
    {
        private databaseConnection dbConnection;

        public static string ActiveUser { get; private set; }

        public Authentication()
        {
            dbConnection = new databaseConnection();
        }

        // Login function that checks credentials
        public bool Login(string username, string password)
        {
            try
            {
                string storedHashedPassword = dbConnection.GetPasswordForUser(username);

                if (!string.IsNullOrEmpty(storedHashedPassword))
                {
                    string hashedInputPassword = hashPassword(password);

                    if (storedHashedPassword == hashedInputPassword)
                    {
                        ActiveUser = username; // Set active user session
                        return true;
                    }
                    else
                    {
                        MessageBox.Show("Incorrect username or password.");
                        return false;
                    }
                }
                else
                {
                    MessageBox.Show("Incorrect username of password.");
                    return false;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error: " + ex.Message);
                return false;
            }
        }

        // Register a new user
        public bool Register(string username, string password)
        {
            // Check if the username is already taken
            if (dbConnection.IsUsernameTaken(username))
            {
                MessageBox.Show("Username already taken.");
                return false;
            }

            // Hash the password and add the user to the database
            string hashedPassword = hashPassword(password);
            return dbConnection.AddUser(username, hashedPassword);
        }

        public static void Logout()
        {
            ActiveUser = null; // Log out the user
        }

        // Hash the password using SHA256
        private string hashPassword(string password)
        {
            using (SHA256 sha256 = SHA256.Create())
            {
                byte[] bytes = sha256.ComputeHash(Encoding.UTF8.GetBytes(password));
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < bytes.Length; i++)
                {
                    builder.Append(bytes[i].ToString("x2"));
                }
                return builder.ToString();
            }
        }
    }
}
